require( "scripts/style.lua" );

SetPauseMenuCanShow(false);
SetConfirmExitCanShow(true);

MakeDialog
{
    SHPanelBuy
    {
        name="panelbuy",
        x = 0,
        y = 0,
        w = 800,
        h = 600,
        
        enter_curve = "config/curves/fx_start.xml",
        exit_curve = "config/curves/fx_end.xml",
        
        Bitmap
        {
            name="panel",
            image="ui/surfaces/panel",
            x=kCenter,
            y=kCenter,

            Bitmap
            {
				name = "shop_frame",
                x = kCenter,
                y = kCenter - 70,
                image="ui/buttons/shop_frame",
                
                Bitmap
                {
                    name="icon",
                    x = 23,
                    y = 20,
                    image="",
                },
                
                SetStyle(CreateTextStyle(FontGame, 19, YellowColor)),
                Text
                {
                    name="text_cost",
                    x=kCenter, y=50,
                },
            },

            SetStyle(CreateTextStyle(FontGame, 22, BlackColor)),
            Text
            {
                name="text_desc",
                x=60,y=kCenter + 40,
                w=kMax-60, h=80,
            },

            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=kCenter - 80,
                y=kCenter + 120,
                name="buy",
                default = true,
                command=
                    function()
                        Upgrade();
                        HideBuyPanel();
                    end,
                SetStyle(CreateTextStyle(FontButtons, 28, WhiteColorAlpha128)),
                CreateText(2,2,"buy", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 28, BlackColor)),
                CreateText(0,0,"buy", 0, 0),
            },

            SetStyle(CreatePushButtonStyle(StandardButtonGraphics, DefaultButtonSound)),
            Button
            {
                x=kCenter + 80,
                y=kCenter + 120,
                name="no",
                command=
                    function()
                        HideBuyPanel();
                    end,
                SetStyle(CreateTextStyle(FontButtons, 28, WhiteColorAlpha128)),
                CreateText(2,2,"no", 0, 0),
                SetStyle(CreateTextStyle(FontButtons, 28, BlackColor)),
                CreateText(0,0,"no", 0, 0),
            },
        },
    },
}